/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_PRECO_TABLOIDE]    Script Date: 02/26/2014 19:52:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE]
GO
GO 
--EXEC P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE 1,33,1
--Procedure para atualização de preços do tabloide

CREATE PROCEDURE [P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE]                 @CD_EMP         INT     = 1, @CD_TABLOIDE    INT     = 0, @ATIVA_DESATIVA TINYINT = 1, @CD_USU_EXEC    INT     = 1

AS

SET NOCOUNT ON;


IF EXISTS (
		SELECT 1
		FROM EST_PROD_TABLOIDE
		WHERE CD_TABLOIDE = @CD_TABLOIDE
		AND (FLAG_ENVIO_PROPZ = 1 AND FLAG_TP_DESCONTO_PROPZ = 1)
		)
BEGIN

	UPDATE PRECO
	SET CD_TABLOIDE = 0,
		VLR_OFERTA = 0
	FROM EST_PROD_PRECO PRECO
	WHERE CD_TABLOIDE = @CD_TABLOIDE

	EXEC P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE_PROPZ_IDENTIFICADO @CD_EMP, @CD_TABLOIDE, @ATIVA_DESATIVA, @CD_USU_EXEC;

	RETURN; /*Sai da procedure, executa apenas o que está na procedure acima*/
END

	UPDATE PRECO
	SET CD_TABLOIDE = 0,
		VLR_OFERTA = 0
	FROM EST_PROD_PRECO_PROPZ_IDENTIFICADO PRECO
	WHERE CD_TABLOIDE = @CD_TABLOIDE


IF EXISTS (
		SELECT 1
		FROM EST_PROD_TABLOIDE
		WHERE CD_TABLOIDE = @CD_TABLOIDE
		AND (FLAG_DESCONTO_EXCLUSIVO_INTEGRACAO = 1 OR ISNULL(FLAG_CANAL_VENDA,0) <> 0)
		)
BEGIN
	RETURN;
END


--------------------------------------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #RSPROD
(
             CD_EMP                  TINYINT
           , CD_TABLOIDE             INT
           , CD_FILIAL               INT
           , CD_PROD                 INT
           , VLR_OFERTA              MONEY
           , VLR_OFERTA_AVISTA       MONEY
           , CD_USU                  INT
           , FLAG_SOBREPOE_DESCONTOS INT
           , TIPO_MAJORACAO          INT
		   , DT_ULT_ALT				 DATETIME
);
-- Versao 3300
CREATE TABLE #TBL_ALTERACAO
(
             CD_EMP                  TINYINT
           , CD_FILIAL               INT
           , CD_PROD                 INT
           , VLR_OFERTA_ATUAL        MONEY
           , VLR_OFERTA_NOVO         MONEY
           , VLR_OFERTA_AVISTA       MONEY
           , VLR_OFERTA_AVISTA_NOVO  MONEY
           , CD_USU                  INT
           , FLAG_SOBREPOE_DESCONTOS INT
           , CD_TABLOIDE             INT
           , TIPO_MAJORACAO          INT
		   , DT_ULT_ALT				 DATETIME
);
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
--Deixando apenas os produtos que foram deletados do tabloide
DELETE EST_PROD_TABLOIDE_CPL_DELETADO
FROM EST_PROD_TABLOIDE_CPL
     INNER JOIN EST_PROD_TABLOIDE_CPL_DELETADO ON EST_PROD_TABLOIDE_CPL.CD_EMP = EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP
                                                  AND EST_PROD_TABLOIDE_CPL.CD_TABLOIDE = EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE
                                                  AND EST_PROD_TABLOIDE_CPL.CD_PROD = EST_PROD_TABLOIDE_CPL_DELETADO.CD_PROD
WHERE
      EST_PROD_TABLOIDE_CPL_DELETADO.FLAG_PROCESSADO = 0
      AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP = @CD_EMP
      AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE;

--Deixando apenas as filiais que foram deletados do tabloide

DELETE EST_PROD_TABLOIDE_FILIAL_DELETADO
FROM EST_PROD_TABLOIDE_FILIAL
     INNER JOIN EST_PROD_TABLOIDE_FILIAL_DELETADO ON EST_PROD_TABLOIDE_FILIAL.CD_EMP = EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP
                                                     AND EST_PROD_TABLOIDE_FILIAL.CD_TABLOIDE = EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE
                                                     AND EST_PROD_TABLOIDE_FILIAL.CD_FILIAL = EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_FILIAL
WHERE
      EST_PROD_TABLOIDE_FILIAL_DELETADO.FLAG_PROCESSADO = 0
      AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP = @CD_EMP
      AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE;
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
--Buscando produtos para colocar em oferta
--------------------------------------------------------------------------------------------------------------------------------------------------------------------

	INSERT INTO EST_PROD_TABLOIDE_EVENTOS(CD_EMP, CD_TABLOIDE, EVENTO, CD_USU, DT_CAD)
	SELECT
			@CD_EMP
		, @CD_TABLOIDE
		, 'PROCESSAMENTO TABLOIDE'
		, @CD_USU_EXEC
		, GETDATE();


	IF @ATIVA_DESATIVA=1
	BEGIN
		Print 'Ativando tabloide '  +  convert(varchar,getdate(),108) 
		INSERT INTO #RSPROD
		SELECT
				EST_PROD_TABLOIDE.CD_EMP
			, EST_PROD_TABLOIDE.CD_TABLOIDE
			, EST_PROD_TABLOIDE_FILIAL.CD_FILIAL
			, c.CD_PROD
			, (c.VLR_GRP_PROD) AS VLR_OFERTA
			, (c.VLR_VISTA) VLR_VISTA
			, c.CD_USU
			, ISNULL(EST_PROD_TABLOIDE.FLAG_SOBREPOE_DESCONTOS, 0)
			, 0 AS TIPO_MAJORACAO
			, COALESCE(EST_PROD_TABLOIDE.DT_ULT_ALT,EST_PROD_TABLOIDE.DT_CAD) AS DT_ULT_ALT
		FROM
			EST_PROD_TABLOIDE
			INNER JOIN EST_PROD_TABLOIDE_CPL c ON EST_PROD_TABLOIDE.CD_EMP = c.CD_EMP
													AND EST_PROD_TABLOIDE.CD_TABLOIDE = c.CD_TABLOIDE
			INNER JOIN EST_PROD_TABLOIDE_FILIAL ON EST_PROD_TABLOIDE.CD_EMP = EST_PROD_TABLOIDE_FILIAL.CD_EMP
													AND EST_PROD_TABLOIDE.CD_TABLOIDE = EST_PROD_TABLOIDE_FILIAL.CD_TABLOIDE
		WHERE EST_PROD_TABLOIDE.CD_EMP = @CD_EMP
				AND EST_PROD_TABLOIDE.CD_TABLOIDE = @CD_TABLOIDE;

	END 
	ELSE
	BEGIN
		--------------------------------------------------------------------------------------------------------------------------------------------------------------------						
		--Buscando produto que estao em oferta para serem zerados exceto os que já tem o novo preço na tabela @RSPROD
		--------------------------------------------------------------------------------------------------------------------------------------------------------------------
		Print 'Desativando tabloide ' +  convert(varchar,getdate(),108)
		INSERT INTO #RSPROD
		SELECT
			   EST_PROD_TABLOIDE.CD_EMP
			 , EST_PROD_TABLOIDE.CD_TABLOIDE
			 , EST_PROD_TABLOIDE_FILIAL.CD_FILIAL
			 , EST_PROD_TABLOIDE_CPL.CD_PROD
			 , 0 VLR_OFERTA
			 , 0 VLR_VISTA
			 , EST_PROD_TABLOIDE.CD_USU
			 , ISNULL(EST_PROD_TABLOIDE.FLAG_SOBREPOE_DESCONTOS, 0)
			 , 0 AS TIPO_MAJORACAO
			 , EST_PROD_TABLOIDE.DT_ULT_ALT
		FROM
			 EST_PROD_TABLOIDE
			 INNER JOIN EST_PROD_TABLOIDE_CPL ON EST_PROD_TABLOIDE.CD_EMP = EST_PROD_TABLOIDE_CPL.CD_EMP
												 AND EST_PROD_TABLOIDE.CD_TABLOIDE = EST_PROD_TABLOIDE_CPL.CD_TABLOIDE
			 INNER JOIN EST_PROD_TABLOIDE_FILIAL ON EST_PROD_TABLOIDE.CD_EMP = EST_PROD_TABLOIDE_FILIAL.CD_EMP
													AND EST_PROD_TABLOIDE.CD_TABLOIDE = EST_PROD_TABLOIDE_FILIAL.CD_TABLOIDE
		WHERE EST_PROD_TABLOIDE.CD_TABLOIDE = @CD_TABLOIDE
			  -- AND EST_PROD_TABLOIDE_CPL.FLAG_PRECO_SUBST = 0
			  AND EST_PROD_TABLOIDE_CPL.CD_EMP = @CD_EMP;
	   -------------------------------------------------------------------------------------------------------------------
	   --Verifica se o produtos estao em outro tabloide
	   UPDATE p
		  SET
			  p.VLR_OFERTA = outroTbl.VLR_OFERTA
			, p.VLR_OFERTA_AVISTA = outroTbl.VLR_VISTA
			, p.FLAG_SOBREPOE_DESCONTOS = ISNULL(outroTbl.FLAG_SOBREPOE_DESCONTOS, 0)
			, p.CD_TABLOIDE = outroTbl.CD_TABLOIDE
		FROM #RSPROD p
			 JOIN ( SELECT
							t.CD_EMP
							, f.CD_FILIAL
							, c.CD_PROD
							, MIN(c.VLR_GRP_PROD) AS VLR_OFERTA
							, MIN(c.VLR_VISTA) VLR_VISTA
							, ISNULL(t.FLAG_SOBREPOE_DESCONTOS, 0) FLAG_SOBREPOE_DESCONTOS
							, t.CD_TABLOIDE
					FROM
							EST_PROD_TABLOIDE t
							INNER JOIN EST_PROD_TABLOIDE_CPL c ON t.CD_EMP = c.CD_EMP
																AND t.CD_TABLOIDE = c.CD_TABLOIDE
							INNER JOIN EST_PROD_TABLOIDE_FILIAL f ON t.CD_EMP = f.CD_EMP
																	AND t.CD_TABLOIDE = f.CD_TABLOIDE
					WHERE t.CD_TABLOIDE != @CD_TABLOIDE
							AND CONVERT(DATE, GETDATE()) BETWEEN t.DT_INICIO AND t.DT_FIM
							AND t.FLAG_VIGENCIA IN(1, 0)
							AND c.CD_EMP = @CD_EMP
							AND ISNULL(T.FLAG_DESCONTO_EXCLUSIVO_INTEGRACAO,0) = 0
							AND ISNULL(T.FLAG_CANAL_VENDA,0) = 0
							AND ISNULL(T.FLAG_TP_DESCONTO_PROPZ,0) = 0
							AND ISNULL(T.FLAG_ENVIO_PROPZ,0) = 0
					GROUP BY
								t.CD_EMP
							, f.CD_FILIAL
							, c.CD_PROD
							, t.FLAG_SOBREPOE_DESCONTOS
							, t.CD_TABLOIDE
					) outroTbl ON p.CD_EMP = outroTbl.CD_EMP
								  AND p.CD_FILIAL = outroTbl.CD_FILIAL
								  AND p.CD_PROD = outroTbl.CD_PROD;				
	END

	-------------------------------------------------------------------------------------------------------------------
	--Criando indice para facilitar a consulta	
	CREATE UNIQUE NONCLUSTERED INDEX IX_#RSPROD000222C2 ON 
		[dbo].[#RSPROD] (CD_PROD,CD_FILIAL,CD_EMP) 
		include ([VLR_OFERTA],VLR_OFERTA_AVISTA);
 			
	-------------------------------------------------------------------------------------------------------------------
	Print 'Produtos para alteracao - '+ convert(varchar,getdate(),108) 			
	INSERT INTO #TBL_ALTERACAO 							
	SELECT
		P.CD_EMP
		, P.CD_FILIAL
		, P.CD_PROD
		, P.VLR_OFERTA
		, ISNULL(R.VLR_OFERTA, 0)
		, P.VLR_OFERTA_AVISTA
		, ISNULL(R.VLR_OFERTA_AVISTA, 0)
		, CASE
			WHEN ISNULL(R.CD_USU, 0) = 0 THEN P.CD_USU
			ELSE R.CD_USU
		END
		, ISNULL(R.FLAG_SOBREPOE_DESCONTOS, 0)
		, R.CD_TABLOIDE
		, R.TIPO_MAJORACAO
		, R.DT_ULT_ALT
	FROM
		EST_PROD_PRECO P WITH (nolock)
		JOIN #RSPROD R ON P.CD_EMP = R.CD_EMP
						AND P.CD_FILIAL = R.CD_FILIAL
						AND P.CD_PROD = R.CD_PROD
		LEFT JOIN EST_PROD_TABLOIDE_CPL_OFERTA_ZERAR z ON P.CD_EMP = z.CD_EMP
														AND P.CD_FILIAL = z.CD_FILIAL
														AND P.CD_PROD = z.CD_PROD
	WHERE P.CD_EMP = 1
		AND ISNULL(P.PRECO_ESPECIFICO, 0) <> 1
		AND Z.CD_EMP IS NULL;

	-------------------------------------------------------------------------------------------------------------------	
	CREATE CLUSTERED INDEX IX_#TBL_ALTERACAO ON #TBL_ALTERACAO (CD_PROD,CD_FILIAL,CD_EMP) 
		
	DELETE FROM R
	FROM 
		EST_PROD_PRECO p  with (nolock) 
		INNER JOIN 	#TBL_ALTERACAO r  ON
		P.CD_EMP     =  R.CD_EMP AND
		P.CD_FILIAL  =  R.CD_FILIAL AND
		P.CD_PROD    =  R.CD_PROD 
	WHERE
		(p.VLR_OFERTA = R.VLR_OFERTA_NOVO)
		and (p.VLR_OFERTA_AVISTA = R.VLR_OFERTA_AVISTA_NOVO)
		and p.FLAG_SOBREPOE_DESCONTOS = r.FLAG_SOBREPOE_DESCONTOS;

	Print 'Removeu registros sem alteracao - Time '+ convert(varchar,getdate(),108)  

-------------------------------------------------------------------------------------------------------------------
--zerando valor em ofertas para produtos,filiais que estão na tabela EST_PROD_TABLOIDE_CPL_OFERTA_ZERAR
------------------------------------------------------------------------------------------------------------------

		CREATE TABLE #TBL_ZERAR_OFERTA(CD_EMP           INT
									   , CD_FILIAL        INT
									   , CD_PROD          INT
									   , VLR_OFERTA_ATUAL MONEY
									   , CD_USU           INT);				

		INSERT INTO #TBL_ZERAR_OFERTA
		SELECT
				P.CD_EMP
			, P.CD_FILIAL
			, P.CD_PROD
			, 0
			, CASE
					WHEN ISNULL(R.CD_USU, 0) = 0 THEN P.CD_USU
					ELSE R.CD_USU
				END
		FROM
			EST_PROD_PRECO P
			INNER JOIN EST_PROD_TABLOIDE_CPL_OFERTA_ZERAR R ON P.CD_EMP = R.CD_EMP
																AND P.CD_FILIAL = R.CD_FILIAL
																AND P.CD_PROD = R.CD_PROD
		WHERE P.CD_EMP = @CD_EMP
		UNION ALL
		SELECT
				EST_PROD_TABLOIDE_FILIAL.CD_EMP
			, EST_PROD_TABLOIDE_FILIAL.CD_FILIAL
			, EST_PROD_TABLOIDE_CPL_DELETADO.CD_PROD
			, 0
			, EST_PROD_TABLOIDE.CD_USU
		FROM
			EST_PROD_TABLOIDE_FILIAL
			INNER JOIN EST_PROD_TABLOIDE_CPL_DELETADO ON EST_PROD_TABLOIDE_FILIAL.CD_EMP = EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP
															AND EST_PROD_TABLOIDE_FILIAL.CD_TABLOIDE = EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE
			INNER JOIN EST_PROD_TABLOIDE ON EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP = EST_PROD_TABLOIDE.CD_EMP
											AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE = EST_PROD_TABLOIDE.CD_TABLOIDE
		WHERE EST_PROD_TABLOIDE_CPL_DELETADO.FLAG_PROCESSADO = 0
				AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP = @CD_EMP
				AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE
		UNION ALL
		SELECT
				EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP
			, EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_FILIAL
			, EST_PROD_TABLOIDE_CPL.CD_PROD
			, 0
			, EST_PROD_TABLOIDE.CD_USU
		FROM
			EST_PROD_TABLOIDE_CPL
			INNER JOIN EST_PROD_TABLOIDE_FILIAL_DELETADO ON EST_PROD_TABLOIDE_CPL.CD_EMP = EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP
															AND EST_PROD_TABLOIDE_CPL.CD_TABLOIDE = EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE
			INNER JOIN EST_PROD_TABLOIDE ON EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP = EST_PROD_TABLOIDE.CD_EMP
											AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE = EST_PROD_TABLOIDE.CD_TABLOIDE
		WHERE EST_PROD_TABLOIDE_FILIAL_DELETADO.FLAG_PROCESSADO = 0
				AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP = @CD_EMP
				AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE;

-------------------------------------------------------------------------------------------------------------------
---- ZENDO VALOR OFERTA POR FILIAL, PARA PRODUTOS QUE ESTEJA NA TABELA (EST_PROD_TABLOIDE_CPL_OFERTA_ZERAR)
-------------------------------------------------------------------------------------------------------------------

		PRINT 'Zerando valor em ofertas para produtos configurados no tabloide para zera valor oferta.  Time '+CONVERT(VARCHAR, GETDATE(), 108);

		UPDATE p
		  SET
			  p.VLR_OFERTA = 0
			, p.VLR_OFERTA_AVISTA = 0
			, p.CD_USU = r.CD_USU
			, p.DT_CAD = CONVERT(CHAR(10), GETDATE(), 112)
			, P.CD_TABLOIDE = 0
			, P.FLAG_SOBREPOE_DESCONTOS = 0
			, TIPO_MAJORACAO = 0
		FROM EST_PROD_PRECO p
			 INNER JOIN #TBL_ZERAR_OFERTA r ON P.CD_EMP = R.CD_EMP
											   AND P.CD_FILIAL = R.CD_FILIAL
											   AND P.CD_PROD = R.CD_PROD
		WHERE
			  p.cd_emp = @cd_emp;

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--Atualizando os preços de oferta (Preços de novos tablóides e zerando os preços que não estão mais em tabóides)
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
		DECLARE @filial INT;

		PRINT 'Atualizando os preços de oferta (Preços de novos tablóides e zerando os preços que não estão mais em tabóides)  Time '+CONVERT(VARCHAR, GETDATE(), 108);

		DECLARE cAltera CURSOR FAST_FORWARD READ_ONLY
		FOR SELECT DISTINCT CD_FILIAL
			FROM
				 #TBL_ALTERACAO
			ORDER BY cd_filial;

		OPEN cAltera;
		FETCH NEXT FROM cAltera INTO @filial;
		WHILE @@FETCH_STATUS = 0
			BEGIN
				PRINT 'Atualizando tabloide '+CONVERT(VARCHAR(10), @cd_tabloide)+' Filial '+CONVERT(VARCHAR(10), @filial);
				UPDATE p
				  SET
					  p.VLR_OFERTA = R.VLR_OFERTA_NOVO
					, p.VLR_OFERTA_AVISTA = R.VLR_OFERTA_AVISTA_NOVO
					, p.CD_USU = r.CD_USU
					, p.DT_CAD = GETDATE() --- salvar data última alteração tabloide
					, P.CD_TABLOIDE = R.CD_TABLOIDE
					, P.FLAG_SOBREPOE_DESCONTOS = ISNULL(R.FLAG_SOBREPOE_DESCONTOS, 0)
					, TIPO_MAJORACAO = r.TIPO_MAJORACAO
					, P.DT_ULT_ALT = R.DT_ULT_ALT
				FROM EST_PROD_PRECO p
					 INNER JOIN #TBL_ALTERACAO r ON P.CD_EMP = R.CD_EMP
													AND P.CD_FILIAL = R.CD_FILIAL
													AND P.CD_PROD = R.CD_PROD
				WHERE
					  p.cd_emp = @cd_emp
					  AND P.CD_FILIAL = @filial;
				FETCH NEXT FROM cAltera INTO @filial;
			END;

		CLOSE cAltera;
		DEALLOCATE cAltera;	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--Alterando tabloide dizendo que não esta mais em uso
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
	PRINT 'Alterando status do tabloide Time '+CONVERT(VARCHAR, GETDATE(), 108);

	IF @ATIVA_DESATIVA = 0
		BEGIN
			UPDATE t
			  SET
				  t.FLAG_VIGENCIA = 2
			FROM EST_PROD_TABLOIDE t
			WHERE
				  t.cd_emp = @cd_emp
				  AND t.CD_TABLOIDE = @CD_TABLOIDE;
		END;
		ELSE
		BEGIN
			UPDATE t
			  SET
				  t.FLAG_VIGENCIA = 1
			FROM EST_PROD_TABLOIDE t
			WHERE
				  t.cd_emp = @cd_emp
				  AND t.CD_TABLOIDE = @CD_TABLOIDE;
		END;
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
	--Marcando como processado
	UPDATE EST_PROD_TABLOIDE_CPL_DELETADO
	  SET
		  EST_PROD_TABLOIDE_CPL_DELETADO.FLAG_PROCESSADO = 1
	FROM EST_PROD_TABLOIDE_CPL_DELETADO
	WHERE
		  EST_PROD_TABLOIDE_CPL_DELETADO.FLAG_PROCESSADO = 0
		  AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_EMP = @CD_EMP
		  AND EST_PROD_TABLOIDE_CPL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE;

	--Marcando como processado FILIAL
	UPDATE EST_PROD_TABLOIDE_FILIAL_DELETADO
	  SET
		  EST_PROD_TABLOIDE_FILIAL_DELETADO.FLAG_PROCESSADO = 1
	FROM EST_PROD_TABLOIDE_FILIAL_DELETADO
	WHERE
		  EST_PROD_TABLOIDE_FILIAL_DELETADO.FLAG_PROCESSADO = 0
		  AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_EMP = @CD_EMP
		  AND EST_PROD_TABLOIDE_FILIAL_DELETADO.CD_TABLOIDE = @CD_TABLOIDE;
	 
--------------------------------------------------------------------------------------------------------------------------------------------------------------------